#ifndef ExpressionDict_H
#define ExpressionDict_H

#include "Hashtable.h"
#include "nodeClass.h"


class FcnEntry : public nodeClass {

	public:
		UtilStr					mName;
		long					mSize;
		float**					mFcn;

};



class ExpressionDict {


	public:
								ExpressionDict();
								
								
		void					AddVar( UtilStr& inKey, float* inPtr )				{ AddVar( inKey.getCStr(), inPtr );	}
		void					AddVar( char* inKey, float* inPtr );
		
		void					AddFcn( char* inKey, float* inFArray[], long inSize );


		float*					LookupVar( const UtilStr& inName );
		float**					LookupFunc( const UtilStr& inName, long& outSize );
		
	protected:
		Hashtable				mVarDict;
		nodeClass				mFcnEntries;

};


#endif




